/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.integration;

import com.hoshino.cti.Plugin.JEIPlugin;
import com.hoshino.cti.recipe.AnnihilationPanelRecipe;
import com.hoshino.cti.register.CtiItem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.client.jei.MekanismJEI;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class AnnihilationPanelRecipeCategory
implements IRecipeCategory<AnnihilationPanelRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("cti", "panel_recipe");
    public static final ResourceLocation TEXTURE = new ResourceLocation("cti", "textures/gui/jei/annihilation_panel_bg.png");
    private final IDrawable background;
    private final IDrawable icon;

    public AnnihilationPanelRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 184, 42);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CtiItem.meteorium_plane.get()));
    }

    public RecipeType<AnnihilationPanelRecipe> getRecipeType() {
        return JEIPlugin.PANEL_RECIPE;
    }

    public Component getTitle() {
        return Component.m_237113_((String)"\u9762\u677f\u91c7\u96c6");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AnnihilationPanelRecipe recipe, IFocusGroup focuses) {
        int h;
        int w;
        builder.addSlot(RecipeIngredientRole.INPUT, 11, 13).addItemStack(new ItemStack(recipe.panel));
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(List.copyOf(recipe.itemOutputs));
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>(List.copyOf(recipe.fluidOutputs));
        ArrayList chemicals = new ArrayList(List.copyOf(recipe.chemicalOutputs));
        int added = 0;
        for (ItemStack itemStack : items) {
            if (added < 5) {
                w = 85 + 18 * added;
                h = 4;
            } else {
                w = 85 + 18 * (added - 5);
                h = 22;
            }
            builder.addSlot(RecipeIngredientRole.OUTPUT, w, h).addItemStack(itemStack);
            if (++added < 10) continue;
            break;
        }
        if (added < 10) {
            for (FluidStack fluidStack : fluids) {
                if (added < 5) {
                    w = 85 + 18 * added;
                    h = 4;
                } else {
                    w = 85 + 18 * (added - 5);
                    h = 22;
                }
                builder.addSlot(RecipeIngredientRole.OUTPUT, w, h).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)fluidStack);
                if (++added < 10) continue;
                break;
            }
        }
        if (added < 10) {
            for (ChemicalStack chemicalStack : chemicals) {
                if (added < 5) {
                    w = 85 + 18 * added;
                    h = 4;
                } else {
                    w = 85 + 18 * (added - 5);
                    h = 22;
                }
                AnnihilationPanelRecipeCategory.addChemicalSlot(RecipeIngredientRole.OUTPUT, w, h, builder, chemicalStack);
                if (++added < 10) continue;
                break;
            }
        }
    }

    public static void addChemicalSlot(RecipeIngredientRole role, int u, int v, IRecipeLayoutBuilder builder, ChemicalStack<?> stack) {
        if (stack instanceof GasStack) {
            GasStack gasStack = (GasStack)stack;
            builder.addSlot(role, u, v).addIngredient(MekanismJEI.TYPE_GAS, (Object)gasStack);
        } else if (stack instanceof InfusionStack) {
            InfusionStack infusionStack = (InfusionStack)stack;
            builder.addSlot(role, u, v).addIngredient(MekanismJEI.TYPE_INFUSION, (Object)infusionStack);
        } else if (stack instanceof SlurryStack) {
            SlurryStack slurryStack = (SlurryStack)stack;
            builder.addSlot(role, u, v).addIngredient(MekanismJEI.TYPE_SLURRY, (Object)slurryStack);
        } else if (stack instanceof PigmentStack) {
            PigmentStack pigmentStack = (PigmentStack)stack;
            builder.addSlot(role, u, v).addIngredient(MekanismJEI.TYPE_PIGMENT, (Object)pigmentStack);
        }
    }

    public void draw(AnnihilationPanelRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        if (recipe.dimension != null) {
            String dim = recipe.dimension.m_135782_().m_214298_();
            MutableComponent dimension = Component.m_237113_((String)"\u7ef4\u5ea6:").m_130940_(ChatFormatting.DARK_GRAY);
            dimension.m_7220_((Component)Component.m_237115_((String)("dimension." + dim)).m_130940_(ChatFormatting.DARK_GRAY));
            Minecraft.m_91087_().f_91062_.m_92889_(stack, (Component)dimension, 2.0f, 0.0f, 0);
        }
        if (recipe.additionalCondition != null) {
            Minecraft.m_91087_().f_91062_.m_92889_(stack, recipe.additionalCondition, 32.0f, 8.0f, 0);
        }
        if (!recipe.condition.description.isEmpty()) {
            Minecraft.m_91087_().f_91062_.m_92889_(stack, (Component)Component.m_237115_((String)recipe.condition.description).m_130948_(Style.f_131099_.m_178520_(3944779)), 2.0f, 32.0f, 0);
        }
        Minecraft.m_91087_().f_91062_.m_92889_(stack, (Component)Component.m_237113_((String)(recipe.ticks + " Ticks")), 32.0f, 16.0f, 0);
    }
}

